// This MFC Samples source code demonstrates using MFC Microsoft Office Fluent User Interface 
// (the "Fluent UI") and is provided only as referential material to supplement the 
// Microsoft Foundation Classes Reference and related electronic documentation 
// included with the MFC C++ library software.  
// License terms to copy, use or distribute the Fluent UI are available separately.  
// To learn more about our Fluent UI licensing program, please visit 
// http://msdn.microsoft.com/officeui.
//
// Copyright (C) Microsoft Corporation
// All rights reserved.

// bbDemoView.h : interface of the CbbDemoView class
//

#pragma once

class CbbDemoView : public CView
{
protected: // create from serialization only
	CbbDemoView();
	DECLARE_DYNCREATE(CbbDemoView)

public: /* Members */

public: /* Methods */
	CbbDemoDoc* GetDocument() const;
	
private: /* Members */
	const static int margin = 60;
	enum JUSTIFICATION {LEFT, RIGHT, CENTER};

	CDC* m_cDC;                    // Device Context
	HGLRC m_hRC;                   // Rendering Context
	HFONT font;
	GLuint fontHandle;

	int viewWidth, viewHeight;
	int gratX, gratY;

	std::vector<float> graticule, signal;

	GLuint gratVBO, signalVBO;

private: /* Methods */
	void glInit(void);
	void createGraticule(void);
	void rastText(const CString& s, JUSTIFICATION just, int x, int y);
	void myPrint(const char* s);
	void normalizeSignal(void);
	void drawSweep(void);
	void drawChannel(Channel c, float f);

	HFONT getFont(int h, int w, char* name);

public: /* Overrides */
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:

public: /* Implementation */
	virtual ~CbbDemoView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

protected: /* Message Map */
	afx_msg void OnFilePrintPreview();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
};

#ifndef _DEBUG  // debug version in bbDemoView.cpp
inline CbbDemoDoc* CbbDemoView::GetDocument() const
   { return reinterpret_cast<CbbDemoDoc*>(m_pDocument); }
#endif

